package com.ejie.ab04b.service;

import java.util.List;
import java.util.Locale;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.TipoCambio;
import com.ejie.ab04b.dao.ApartadoAnexoIDao;
import com.ejie.ab04b.dao.ApartadoAnexoIIDao;
import com.ejie.ab04b.dao.ClaseCentroTrabajoDao;
import com.ejie.ab04b.dao.CnaeJ73Dao;
import com.ejie.ab04b.dao.EntidadGestoraColaboradoraDao;
import com.ejie.ab04b.dao.HistCambiosAperturasDao;
import com.ejie.ab04b.dao.ModalidadOrganizacionPreventivaDao;
import com.ejie.ab04b.dao.TipoAperturaDao;
import com.ejie.ab04b.dao.TipoObraDao;
import com.ejie.ab04b.dao.nora.LocalidadDao;
import com.ejie.ab04b.dao.nora.MunicipioDao;
import com.ejie.ab04b.dao.nora.PaisDao;
import com.ejie.ab04b.dao.nora.ProvinciaDao;
import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.ApartadoAnexoI;
import com.ejie.ab04b.model.ApartadoAnexoII;
import com.ejie.ab04b.model.ClaseCentroTrabajo;
import com.ejie.ab04b.model.CnaeJ73;
import com.ejie.ab04b.model.EntidadGestoraColaboradora;
import com.ejie.ab04b.model.HistCambiosAperturas;
import com.ejie.ab04b.model.ModalidadOrganizacionPreventiva;
import com.ejie.ab04b.model.TipoApertura;
import com.ejie.ab04b.model.TipoObra;
import com.ejie.ab04b.model.nora.Localidad;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Pais;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.util.FcasNameParser;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0487s00ServiceImpl generated by UDA, 27-feb-2017 9:02:46.
 * 
 * @author UDA
 */

@Service(value = "histCambiosAperturasService")
public class HistCambiosAperturasServiceImpl implements
		HistCambiosAperturasService {

	@Autowired
	private HistCambiosAperturasDao ab0487s00Dao;

	@Autowired
	private PaisDao paisDao;

	@Autowired
	private ProvinciaDao provinciaDao;

	@Autowired
	private MunicipioDao municipioDao;

	@Autowired
	private LocalidadDao localidadDao;

	@Autowired
	private CnaeJ73Dao cnaeJ73Dao;

	@Autowired
	private EntidadGestoraColaboradoraDao entidadGestoraColaboradoraDao;

	@Autowired
	private TipoAperturaDao tipoAperturaDao;

	@Autowired
	private ClaseCentroTrabajoDao claseCentroTrabajoDao;

	@Autowired
	private ModalidadOrganizacionPreventivaDao modalidadOrganizacionPreventivaDao;

	@Autowired
	private ApartadoAnexoIDao apartadoAnexoIDao;

	@Autowired
	private ApartadoAnexoIIDao apartadoAnexoIIDao;

	@Autowired()
	private TipoObraDao tipoObraDao;

	@Autowired()
	private ReloadableResourceBundleMessageSource appMessageSource;

	private String terEmpOrig;
	private String terCtrOrig;
	private String terObrOrig;
	private String terEmpModif;
	private String terCtrModif;
	private String terObrModif;

	/**
	 * Inserts a single row in the Ab0487s00 table.
	 * 
	 * ab0487s00 Ab0487s00 Ab0487s00
	 * 
	 * @param ab0487s00
	 *            the ab 0487 s 00
	 * @return the hist cambios aperturas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public HistCambiosAperturas add(HistCambiosAperturas ab0487s00) {
		return this.ab0487s00Dao.add(ab0487s00);
	}

	/**
	 * Updates a single row in the Ab0487s00 table.
	 * 
	 * ab0487s00 Ab0487s00 Ab0487s00
	 * 
	 * @param ab0487s00
	 *            the ab 0487 s 00
	 * @return the hist cambios aperturas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public HistCambiosAperturas update(HistCambiosAperturas ab0487s00) {
		return this.ab0487s00Dao.update(ab0487s00);
	}

	/**
	 * Finds a single row in the Ab0487s00 table.
	 * 
	 * ab0487s00 Ab0487s00 Ab0487s00
	 * 
	 * @param ab0487s00
	 *            the ab 0487 s 00
	 * @return the hist cambios aperturas
	 */
	public HistCambiosAperturas find(HistCambiosAperturas ab0487s00) {
		return (HistCambiosAperturas) this.ab0487s00Dao.find(ab0487s00);
	}

	/**
	 * Deletes a single row in the Ab0487s00 table.
	 * 
	 * ab0487s00 Ab0487s00
	 * 
	 * @param ab0487s00
	 *            the ab 0487 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(HistCambiosAperturas ab0487s00) {
		this.ab0487s00Dao.remove(ab0487s00);
	}

	/**
	 * Finds a list of rows in the Ab0487s00 table.
	 * 
	 * ab0487s00 Ab0487s00 jqGridRequestDto JQGridRequestDto List<Ab0487s00>
	 * 
	 * @param ab0487s00
	 *            the ab 0487 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	public List<HistCambiosAperturas> findAll(HistCambiosAperturas ab0487s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<HistCambiosAperturas>) this.ab0487s00Dao.findAll(
				ab0487s00, jqGridRequestDto);
	}

	/**
	 * Finds a list of rows in the Ab0487s00 table.
	 * 
	 * ab0487s00 Ab0487s00 jqGridRequestDto JQGridRequestDto idioma String
	 * List<Ab0487s00>
	 * 
	 * @param ab0487s00
	 *            the ab 0487 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param idioma
	 *            the idioma
	 * @return the list
	 */
	public List<HistCambiosAperturas> findAllConComparador(
			HistCambiosAperturas ab0487s00, JQGridRequestDto jqGridRequestDto,
			String idioma) {
		List<HistCambiosAperturas> listaCambios = (List<HistCambiosAperturas>) this.ab0487s00Dao
				.findAll(ab0487s00, jqGridRequestDto);
		StringBuffer original = new StringBuffer();
		StringBuffer modif = new StringBuffer();
		if (listaCambios != null && !listaCambios.isEmpty()) {

			for (HistCambiosAperturas cambiosAux : listaCambios) {
				original = new StringBuffer();
				modif = new StringBuffer();
				cargarDiferenciasHistorico(cambiosAux, original, modif,
						cambiosAux.getTipocambio087(), idioma, appMessageSource);
				cambiosAux.setDatosMostrarOriginal(original.toString());
				cambiosAux.setDatosMostrarModif(modif.toString());
			}
		}

		return listaCambios;
	}

	/**
	 * Finds rows in the Ab0487s00 table using like.
	 * 
	 * ab0487s00 Ab0487s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0487s00>
	 * 
	 * @param ab0487s00
	 *            the ab 0487 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<HistCambiosAperturas> findAllLike(
			HistCambiosAperturas ab0487s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		return (List<HistCambiosAperturas>) this.ab0487s00Dao.findAllLike(
				ab0487s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Removes rows from the Ab0487s00 table.
	 * 
	 * filterAb0487s00 Ab0487s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean
	 * 
	 * @param filterAb0487s00
	 *            the filter ab 0487 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 */
	public void removeMultiple(HistCambiosAperturas filterAb0487s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		this.ab0487s00Dao.removeMultiple(filterAb0487s00, jqGridRequestDto,
				startsWith);
	}

	/**
	 * Filter method in the Ab0487s00 table.
	 * 
	 * filterAb0487s00 Ab0487s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<Ab0487s00>
	 * 
	 * @param filterAb0487s00
	 *            the filter ab 0487 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<HistCambiosAperturas> filter(
			HistCambiosAperturas filterAb0487s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<HistCambiosAperturas> listaAb0487s00 = this.ab0487s00Dao
				.findAllLike(filterAb0487s00, jqGridRequestDto, false);
		Long recordNum = this.ab0487s00Dao.findAllLikeCount(
				filterAb0487s00 != null ? filterAb0487s00
						: new HistCambiosAperturas(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<HistCambiosAperturas>> reorderSelection = this.ab0487s00Dao
					.reorderSelection(filterAb0487s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<HistCambiosAperturas>(
					jqGridRequestDto, recordNum, listaAb0487s00,
					reorderSelection);
		}
		return new JQGridResponseDto<HistCambiosAperturas>(jqGridRequestDto,
				recordNum, listaAb0487s00);
	}

	/**
	 * Searches rows in the Ab0487s00 table.
	 * 
	 * filterAb0487s00 Ab0487s00 searchAb0487s00 Ab0487s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0487s00>>
	 * 
	 * @param filterAb0487s00
	 *            the filter ab 0487 s 00
	 * @param searchAb0487s00
	 *            the search ab 0487 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	public List<TableRowDto<HistCambiosAperturas>> search(
			HistCambiosAperturas filterAb0487s00,
			HistCambiosAperturas searchAb0487s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0487s00Dao.search(filterAb0487s00, searchAb0487s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0487s00 table.
	 * 
	 * filterAb0487s00 Ab0487s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean Object
	 * 
	 * @param filterAb0487s00
	 *            the filter ab 0487 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the object
	 */
	public Object reorderSelection(HistCambiosAperturas filterAb0487s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0487s00Dao.reorderSelection(filterAb0487s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Cargar diferencias historico.
	 * 
	 * @param historico
	 *            HistCambiosAperturas
	 * @param original
	 *            StringBuffer
	 * @param modif
	 *            StringBuffer
	 * @param tipoCambio
	 *            String
	 * @param idioma
	 *            String
	 * @param appMessageSource
	 *            ReloadableResourceBundleMessageSource
	 */
	private void cargarDiferenciasHistorico(HistCambiosAperturas historico,
			StringBuffer original, StringBuffer modif, String tipoCambio,
			String idioma,
			ReloadableResourceBundleMessageSource appMessageSource) {

		this.appMessageSource = appMessageSource;
		String apeModif = historico.getRegmidificaciones087();
		String apeOriginal = historico.getRegoriginal087();

		Locale locale = new Locale(idioma);

		// empezamos a recorrer por etiquetas
		// cambio de coordinador

		if (historico.getTipocambio087().equalsIgnoreCase(
				TipoCambio.COORD_EJEC_OBRA.getCodigo())) {
			original.append("<ul class='listaCambiosUl'>");
			modif.append("<ul class='listaCambiosUl'>");
			this.comparador(apeOriginal, apeModif, "tipoCoordinador", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "numeroDocumento", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "tipoDocumento", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaBaja", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaAlta", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "nombreCoordinador",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "descripcionMunicipio",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "direccion", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "codigoPostal", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "titulacion", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "telefono", original, modif,
					locale);
			this.comparador(apeOriginal, apeModif, "territorioExpediente",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "anioExpediente", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "numeroExpediente",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "ordenExpediente", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "usuarioAlta", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaModificacion",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "usuarioModificacion",
					original, modif, locale);
			try {
				this.comparadorFCA(apeOriginal, apeModif, "descripcionFCA",
						original, modif, locale, idioma);
			} catch (Exception e) {
				e.printStackTrace();
			}
			original.append("</ul>");
			modif.append("</ul>");

		} else if (historico.getTipocambio087().equalsIgnoreCase(
				TipoCambio.MODIFICACION_APERTURA.getCodigo())
				|| historico.getTipocambio087().equalsIgnoreCase(
						TipoCambio.SUBSANACION_APERTURA.getCodigo())) {

			if (historico.getRegoriginal087().indexOf("pestana") >= 0) {
				// modificarApertura
				this.comparador(apeOriginal, apeModif, "pestana", original,
						modif, locale);
			} else {
				original.append("<ul class='listaCambiosUl'>");
				modif.append("<ul class='listaCambiosUl'>");
			}
			this.comparador(apeOriginal, apeModif, "usuarioModif", original,
					modif, locale);
			// modificarApertura
			this.comparador(apeOriginal, apeModif, "documento", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "territorioAvP056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "anoAvP056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaPresentacion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaCierre056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "empresaNueva056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "tipoDoc056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "numeroDoc056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "nombreEmp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "descripcionMunEmp056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "direccionEmp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "codigoPostalEmp056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "telefonoEmp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "cnaeEmp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "tipoApe056", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "provinciaEmp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "municipioEmp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "paisEmp056", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "provinciaCnTrb056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "territorioCnTrb056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "municipioCnTrb056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "localidadCnTrb056",
					original, modif, locale);

			this.comparador(apeOriginal, apeModif, "entidadEmp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "nombreCnTrb056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "direccionCnTrb056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "codigoPostalCnTrb056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "telefonoCnTrb056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "faxCnTrb056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "emailCnTrb056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "cnaeCnTrb056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "provinciaSgSc056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "numeroSgSc056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "digControlSgSc056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaInicio056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "trbHombres056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "trbMujeres056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "trbTotal056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "claseCnTrb056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "descripcionObra056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "superficie056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "planSg056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "canalPlan056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "planPresentacion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "proyectoTecnico056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "descMaquinaria056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "potencia056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "indAnexo056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "apdoAnexo056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "descTrb056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "indicadorObra056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "territorioAvP056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "anoAvP056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "numeroAvP056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "loteMnt056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "visOsalan056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "asgOsalan056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "tecOsalan056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaVisitaOsalan056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "visInspeccion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "asgInspeccion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "tecInspeccion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaVisitaInspeccion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaEnvio056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaReq056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaSub056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaInfOsl056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaInfInsp056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaAlta056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "usuarioAlta056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "usuarioModificacion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "descEmp056", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "dirobr082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "locobr082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "terexp082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "munobr082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "desobr082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "tipobr082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "durpre082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "durpreDesde082", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "durpreHasta082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "unitmp082", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "trbtot082", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "trbmuj082", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "trbhom082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "destrab082", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "apdoanx2082", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "indanx2082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "fecini082", original,
					modif, locale);

			this.comparador(apeOriginal, apeModif, "fecfin082", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "descCnTrb056", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "documentacionCorrecta056",
					original, modif, locale);
			// this.comparador(apeOriginal, apeModif, "cnaeCnTrb056", original,
			// modif, locale);
			// this.comparador(apeOriginal, apeModif, "cnaeEmp056", original,
			// modif, locale);
			this.comparador(apeOriginal, apeModif, "modalidadPreventiva056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif,
					"numeroPrevistoConSubAut056", original, modif, locale);
			this.comparador(apeOriginal, apeModif, "acompanaEvalRiesgos056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "canalEvalRiesgos056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif,
					"inscripcionRegistroEmpresa056", original, modif, locale);
			this.comparador(apeOriginal, apeModif, "numeroDocRepresentante056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "tlfRepresentante056",
					original, modif, locale);

			this.comparador(apeOriginal, apeModif, "idiomanotif", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "canalnotif", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "prvnotif", original, modif,
					locale);
			this.comparador(apeOriginal, apeModif, "municnotif", original,
					modif, locale);
			this.comparador(apeOriginal, apeModif, "locnotif", original, modif,
					locale);
			this.comparador(apeOriginal, apeModif, "cpnotif", original, modif,
					locale);
			this.comparador(apeOriginal, apeModif, "dirnotif", original, modif,
					locale);

			original.append("</ul>");
			modif.append("</ul>");

		} else if (historico.getTipocambio087().equalsIgnoreCase(
				TipoCambio.ELIMINACION_APERTURA.getCodigo())) {

			original.append("<ul class='listaCambiosUl'>");
			modif.append("<ul class='listaCambiosUl'>");

			this.comparador(apeOriginal, apeModif, "usuarioModificacion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "fechaModificacion056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "elementoEliminado056",
					original, modif, locale);
			this.comparador(apeOriginal, apeModif, "motivoEliminacion",
					original, modif, locale);

			original.append("</ul>");
			modif.append("</ul>");
		}

	}

	/**
	 * Comparador.
	 * 
	 * @param apeOriginal
	 *            String
	 * @param apeModif
	 *            String
	 * @param label
	 *            String
	 * @param original
	 *            String
	 * @param modif
	 *            String
	 * @param locale
	 *            Locale
	 */
	private void comparador(String apeOriginal, String apeModif, String label,
			StringBuffer original, StringBuffer modif, Locale locale) {
		/*
		 * if (M01BTratarFiltroHistorico.traza.isTraceActive()) {
		 * M01BTratarFiltroHistorico.traza.trace("M01B",Q70TraceLevel.DEBUG ,
		 * "M01BTratarFiltroHistorico comparador(...) "); }
		 */
		int posIni = 0;
		int posFinal = 0;
		String valorTempOrig = "";
		String valorTempModif = "";

		posIni = apeModif.indexOf(label);

		// calculamos la posicion, pero en vez desde la etiqueta, desde el igual
		posIni = apeModif.indexOf("=", posIni);
		if (posIni >= 0) {
			posFinal = apeModif.indexOf(";", posIni + 1);
			valorTempModif = apeModif.substring(posIni + 1, posFinal);
			posIni = apeOriginal.indexOf(label);
			posIni = apeOriginal.indexOf("=", posIni);
			posFinal = apeOriginal.indexOf(";", posIni + 1);
			valorTempOrig = apeOriginal.substring(posIni + 1, posFinal);
			if (valorTempOrig.equalsIgnoreCase("null")) {
				valorTempOrig = "";
			}
			if (valorTempModif.equalsIgnoreCase("null")) {
				// && !"".equals(valorTempOrig)) {
				valorTempModif = "";
			}
			if ("pestana".equals(label)) {

				String labelMostrar = this.appMessageSource.getMessage("label."
						+ label, null, locale)
						+ ": ";
				original.append("<ul class='listaCambiosUl'>");
				modif.append("<ul class='listaCambiosUl'>");
				if (!"".equals(valorTempOrig)) {
					original.append(labelMostrar)
							.append("<span class='datosResaltados'>")
							.append(valorTempOrig).append("</span>");
					modif.append(labelMostrar)
							.append("<span class='datosResaltados'>")
							.append(valorTempOrig).append("</span>");
				}
			}
			if ("usuarioModif".equals(label)) {

				String labelMostrar = this.appMessageSource.getMessage("label."
						+ label, null, locale)
						+ ": ";
				if (!"".equals(valorTempOrig)) {
					original.append(labelMostrar)
							.append("<span class='datosResaltados'>")
							.append(valorTempOrig).append("</span>");
					modif.append(labelMostrar)
							.append("<span class='datosResaltados'>")
							.append(valorTempOrig).append("</span>");
				}
			}
			if ("provinciaEmp056".equals(label)) {
				terEmpOrig = valorTempOrig;
				terEmpModif = valorTempModif;
			} else if ("provinciaCnTrb056".equals(label)) {

				terCtrOrig = valorTempOrig;
				terCtrModif = valorTempModif;
			} else if ("terexp082".equals(label)) {
				terObrOrig = valorTempOrig;
				terObrModif = valorTempModif;
			}

			if (!valorTempOrig.equalsIgnoreCase(valorTempModif)
					&& !"".equals(valorTempModif)) {
				if ("documento".equals(label)) {
					String[] orig = valorTempOrig.split("\\$");
					String[] modifi = valorTempModif.split("\\$");

					for (int i = 0; i < orig.length; i++) {
						original.append("<li class='elementoListaCambio'>")
								.append(orig[i]).append("</li>");
					}
					for (int i = 0; i < modifi.length; i++) {
						modif.append("<li class='elementoListaCambio'>")
								.append(modifi[i]).append("</li>");
					}
				} else {
					String orig = comprobarValor(label, valorTempOrig, locale,
							true);
					String modifi = comprobarValor(label, valorTempModif,
							locale, false);

					String labelMostrar = "<b>"
							+ this.appMessageSource.getMessage(
									"label." + label, null, locale) + ": </b>";

					original.append("<li class='elementoListaCambio'>")
							.append(labelMostrar).append(orig).append("</li>");
					modif.append("<li class='elementoListaCambio'>")
							.append(labelMostrar).append(modifi)
							.append("</li>");
				}
			}
		}
	}

	/**
	 * comprobarValor.
	 * 
	 * @param label
	 *            String
	 * @param valor
	 *            String
	 * @param locale
	 *            locale
	 * @param original
	 *            boolean
	 * @return String
	 */
	private String comprobarValor(String label, String valor, Locale locale,
			boolean original) {
		if ("paisEmp056".equals(label) && !"null".equals(valor)) {
			Pais pais = paisDao.find(new Pais(valor));
			if (pais != null) {
				if ("es".equals(locale.getLanguage())) {
					valor = pais.getDsC();
				} else {
					valor = pais.getDsE();
				}
			}
		} else if (("provinciaCnTrb056".equals(label)
				|| "provinciaEmp056".equals(label) || "terexp082".equals(label))
				&& !"null".equals(valor)) {
			Provincia provincia = provinciaDao.find(new Provincia(valor));
			if (provincia != null) {
				valor = provincia.getDescripcion();
			}
		} else if ("municipioEmp056".equals(label) && !"null".equals(valor)) {
			Municipio muni = new Municipio(valor);
			if (original) {
				muni.setCodProvincia(terEmpOrig);
			} else {
				muni.setCodProvincia(terEmpModif);
			}

			Municipio municipio = municipioDao.find(muni);
			if (municipio != null) {
				valor = municipio.getDescripcion();
			}
		} else if ("municipioCnTrb056".equals(label) && !"null".equals(valor)) {
			Municipio muni = new Municipio(valor);
			if (original) {
				muni.setCodProvincia(terCtrOrig);
			} else {
				muni.setCodProvincia(terCtrModif);
			}
			Municipio municipio = municipioDao.find(muni);
			if (municipio != null) {
				valor = municipio.getDescripcion();
			}
		} else if ("munobr082".equals(label) && !"null".equals(valor)) {
			Municipio muni = new Municipio(valor);
			if (original) {
				muni.setCodProvincia(terObrOrig);
			} else {
				muni.setCodProvincia(terObrModif);
			}

			Municipio municipio = municipioDao.find(muni);
			if (municipio != null) {
				valor = municipio.getDescripcion();
			}
		} else if (("localidadCnTrb056".equals(label) || "locobr082"
				.equals(label)) && !"null".equals(valor)) {
			Localidad localidad = localidadDao.find(new Localidad(valor));
			if (localidad != null) {
				valor = localidad.getDescripcion();
			}
		} else if (("cnaeEmp056".equals(label) || "cnaeCnTrb056".equals(label))
				&& !"null".equals(valor)) {
			CnaeJ73 cnae = new CnaeJ73();
			cnae.setCnae003(valor.trim());
			cnae = cnaeJ73Dao.findByCnae(cnae);
			if (cnae != null) {
				valor = cnae.getDesc003();
			}
		} else if ("entidadEmp056".equals(label) && !"null".equals(valor)) {
			EntidadGestoraColaboradora enti = entidadGestoraColaboradoraDao
					.find(new EntidadGestoraColaboradora(valor));
			if (enti != null) {
				if ("es".equals(locale.getLanguage())) {
					valor = enti.getDesentiatEs078();
				} else {
					valor = enti.getDesentiatEu078();
				}
			}
		} else if ("tipoApe056".equals(label) && !"null".equals(valor)) {
			TipoApertura tipoApe = tipoAperturaDao
					.find(new TipoApertura(valor));
			if (tipoApe != null) {
				if ("es".equals(locale.getLanguage())) {
					valor = tipoApe.getDesapeEs071();
				} else {
					valor = tipoApe.getDesapeEu071();
				}
			}
		} else if ("claseCnTrb056".equals(label) && !"null".equals(valor)) {
			ClaseCentroTrabajo clsCtr = claseCentroTrabajoDao
					.find(new ClaseCentroTrabajo(valor));
			if (clsCtr != null) {
				if ("es".equals(locale.getLanguage())) {
					valor = clsCtr.getDesclasEs072();
				} else {
					valor = clsCtr.getDesclasEu072();
				}
			}
		} else if ("modalidadPreventiva056".equals(label)
				&& !"null".equals(valor)) {
			ModalidadOrganizacionPreventiva mod = modalidadOrganizacionPreventivaDao
					.find(new ModalidadOrganizacionPreventiva(valor));
			if (mod != null) {
				if ("es".equals(locale.getLanguage())) {
					valor = mod.getDesmprEs074();
				} else {
					valor = mod.getDesmprEu074();
				}
			}
		} else if ("apdoAnexo056".equals(label) && !"null".equals(valor)) {
			ApartadoAnexoI anxI = apartadoAnexoIDao.find(new ApartadoAnexoI(
					valor));
			if (anxI != null) {
				if ("es".equals(locale.getLanguage())) {
					valor = anxI.getDesanxEs073();
				} else {
					valor = anxI.getDesanxEu073();
				}
			}
		} else if ("apdoanx2082".equals(label) && !"null".equals(valor)) {
			ApartadoAnexoII anxII = apartadoAnexoIIDao
					.find(new ApartadoAnexoII(valor));
			if (anxII != null) {
				if ("es".equals(locale.getLanguage())) {
					valor = anxII.getDesanx2Es086();
				} else {
					valor = anxII.getDesanx2Eu086();
				}
			}
		} else if ("tipobr082".equals(label) && !"null".equals(valor)) {
			TipoObra tipoObra = tipoObraDao.find(new TipoObra(valor));
			if (tipoObra != null) {
				if ("es".equals(locale.getLanguage())) {
					valor = tipoObra.getDesobrEs070();
				} else {
					valor = tipoObra.getDesobrEu070();
				}
			}
		} else if ("empresaNueva056".equals(label) && !"null".equals(valor)) {
			if ("N".equals(valor)) {
				valor = "es".equals(locale.getLanguage()) ? "Nueva" : "Berria";
			} else {
				valor = "es".equals(locale.getLanguage()) ? "Existente"
						: "Existentea";
			}
		} else if (("tipoDoc056".equals(label) || "tipoDocumento".equals(label))
				&& !"null".equals(valor)) {
			if ("N".equals(valor)) {
				valor = "es".equals(locale.getLanguage()) ? "NIF" : "IFZ";
			} else if ("C".equals(valor)) {
				valor = "es".equals(locale.getLanguage()) ? "CIF" : "IFK";
			} else if ("O".equals(valor)) {
				valor = "es".equals(locale.getLanguage()) ? "Otros"
						: "Bestelakoak";
			}
		} else if (("planSg056".equals(label)
				|| "planPresentacion056".equals(label)
				|| "proyectoTecnico056".equals(label)
				|| "indAnexo056".equals(label)
				|| "indicadorObra056".equals(label)
				|| "asgOsalan056".equals(label)
				|| "asgInspeccion056".equals(label)
				|| "indanx2082".equals(label)
				|| "documentacionCorrecta056".equals(label) || "acompanaEvalRiesgos056"
				.equals(label)) && !"null".equals(valor)) {
			if ("S".equals(valor)) {
				if ("es".equals(locale.getLanguage())) {
					valor = "Si";
				} else {
					valor = "Bai";
				}
			} else if ("N".equals(valor)) {
				if ("es".equals(locale.getLanguage())) {
					valor = "No";
				} else {
					valor = "Ez";
				}
			}
		} else if (("canalPlan056".equals(label) || "canalEvalRiesgos056"
				.equals(label)) && !"null".equals(valor)) {
			if ("T".equals(valor)) {
				if ("es".equals(locale.getLanguage())) {
					valor = "Telemático";
				} else {
					valor = "Telematikoa";
				}
			} else if ("P".equals(valor)) {
				if ("es".equals(locale.getLanguage())) {
					valor = "Presencial";
				} else {
					valor = "Presentziala";
				}
			}
		} else if ("unitmp082".equals(label) && !"null".equals(valor)) {
			if ("D".equals(label)) {
				if ("es".equals(locale.getLanguage())) {
					valor = "dias";
				} else {
					valor = "egunak";
				}
			} else if ("M".equals(label)) {
				if ("es".equals(locale.getLanguage())) {
					valor = "meses";
				} else {
					valor = "hilak";
				}
			} else if ("A".equals(label)) {
				if ("es".equals(locale.getLanguage())) {
					valor = "años";
				} else {
					valor = "urteak";
				}
			}
		} else if ("idiomanotif".equals(label) && !"null".equals(valor)) {
			if ("0".equals(valor)) {
				if ("es".equals(locale.getLanguage())) {
					valor = "Castellano";
				} else {
					valor = "Gaztelania";
				}
			} else if ("1".equals(valor)) {
				if ("es".equals(locale.getLanguage())) {
					valor = "Euskera";
				} else {
					valor = "Euskara";
				}
			}
		} else if ("canalnotif".equals(label) && !"null".equals(valor)) {
			if (Constantes.CANAL_NOTIF_TELEMATICO.equals(valor)) {
				if ("es".equals(locale.getLanguage())) {
					valor = "Telemático";
				} else {
					valor = "Telematikoa";
				}
			} else {
				if ("es".equals(locale.getLanguage())) {
					valor = "Correo Postal";
				} else {
					valor = "Posta";
				}
			}
		}
		return valor;
	}

	/**
	 * Comparador FCA.
	 * 
	 * @param apeOriginal
	 *            String
	 * @param apeModif
	 *            String
	 * @param label
	 *            String
	 * @param original
	 *            String
	 * @param modif
	 *            String
	 * @param locale
	 *            String
	 * @param idioma
	 *            Locale
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	private void comparadorFCA(String apeOriginal, String apeModif,
			String label, StringBuffer original, StringBuffer modif,
			Locale locale, String idioma) throws AB04BException {
		try {
			int posIni = 0;
			int posFinal = 0;
			String valorTempOrig = "";
			String valorTempModif = "";

			posIni = apeModif.indexOf(label);

			// calculamos la posicion, pero en vez desde la etiqueta, desde el
			// igual
			posIni = apeModif.indexOf("=", posIni);
			if (posIni >= 0) {
				posFinal = apeModif.indexOf(";", posIni + 1);
				valorTempModif = apeModif.substring(posIni + 1, posFinal);
				posIni = apeOriginal.indexOf(label);
				posIni = apeOriginal.indexOf("=", posIni);
				posFinal = apeOriginal.indexOf(";", posIni + 1);
				valorTempOrig = apeOriginal.substring(posIni + 1, posFinal);
				if (valorTempOrig.equalsIgnoreCase("null")) {
					valorTempOrig = "";
				}
				if (valorTempModif.equalsIgnoreCase("null")) {
					valorTempModif = "";
				}
				if (!valorTempOrig.equalsIgnoreCase(valorTempModif)) {
					String labelMostrar = "<b>"
							+ this.appMessageSource.getMessage(
									"label." + label, null, locale) + ": </b>";
					original.append("<li class='elementoListaCambio'>")
							.append(labelMostrar)
							.append(this.parsearDesc(valorTempOrig, idioma))
							.append("</li>");
					modif.append("<li class='elementoListaCambio'>")
							.append(labelMostrar)
							.append(this.parsearDesc(valorTempModif, idioma))
							.append("</li>");
				}
			}
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}

	}

	/**
	 * Parsear desc.
	 * 
	 * @param valor
	 *            String
	 * @param idioma
	 *            String
	 * @return String
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	private String parsearDesc(String valor, String idioma)
			throws AB04BException {
		try {

			FcasNameParser fcaparser = new FcasNameParser(valor);

			return fcaparser.getFcasDesc(idioma);
		} catch (Exception e) {
			throw new AB04BException(e, e.getMessage());
		}
	}

}
